class twitch_rabbitmq::server (
  $rabbitmq_config_variables = $twitch_rabbitmq::params::rabbitmq_config_variables,
  $erlang_version            = $twitch_rabbitmq::params::erlang_version,
  $rabbitmq_pkg_version      = $twitch_rabbitmq::params::rabbitmq_pkg_version,
) inherits twitch_rabbitmq::params {

  include erlang

  # erlang pinning directions from here: https://www.rabbitmq.com/install-debian.html#apt-pinning
  apt::pin { 'erlang':
    packages => 'erlang*',
    version  => $erlang_version,
    priority => '900',
    before   => Class['erlang'],
  }

  # pin rabbitmq as well
  apt::pin { 'rabbitmq':
    packages => 'rabbitmq-server',
    version  => $rabbitmq_pkg_version,
    priority => '900',
    before   => Class['rabbitmq'],
  }

  class { '::rabbitmq':
    admin_enable                => true,
    file_limit                  => 262144,
    environment_variables       => {
      'RABBITMQ_USE_LONGNAME' => true,
      'LC_ALL'                => 'en_US.UTF-8'
    },
    config_variables           => $rabbitmq_config_variables,
    wipe_db_on_cookie_change   => true,
    cluster_partition_handling => 'autoheal',
    package_ensure             => $rabbitmq_pkg_version,
    require                    => Class['erlang'],
  }

  logrotate::rule{ 'rabbitmq-server':
    ensure        => present,
    path          => '/var/log/rabbitmq/*.log',
    rotate_every  => 'week',
    missingok     => true,
    rotate        => 20,
    compress      => true,
    delaycompress => true,
    ifempty       => false,
    sharedscripts => true,
    postrotate    => '/etc/init.d/rabbitmq-server rotate-logs > /dev/null',
  }

}
