# Manages a RabbitMQ user through a sandstorm_resource

define twitch_rabbitmq::user (
  $password_key,

  $ensure   = 'present',
  $username = $title,
) {

  twitch_sandstorm_agent::resource { "rabbitmq_user_${username}":
    key             => $password_key,
    exists_command  => "/usr/sbin/rabbitmqctl -q list_users | grep '^${username}'",
    create_command  => "/usr/sbin/rabbitmqctl add_user ${username} %q",
    destroy_command => "/usr/sbin/rabbitmqctl delete_user ${username}",
    in_sync_command => "/usr/sbin/rabbitmqctl authenticate_user ${username} %q",
    update_command  => "/usr/sbin/rabbitmqctl change_password ${username} %q",
    require         => Service['rabbitmq-server'],
  }
}
