class twitch_rabbitmq::video_monitoring inherits twitch_rabbitmq {

  include twitch_nrdp

  $mem_warn      = ceiling($facts['memorysize_mb'] / 1000) * 0.5
  $mem_crit      = ceiling($facts['memorysize_mb'] / 1000) * 0.65

  twitch_nrdp::check { 'rabbitmq memory':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check memory --warn $mem_warn --crit $mem_crit",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq partition':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check partition --warn 1 --crit 1",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_transcode queue - ready':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_transcode_queue --state ready --warn 10 --crit 15",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_transcode queue - unack':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_transcode_queue --state unack --warn 10 --crit 15",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_quicksync queue - ready':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_quicksync_queue --state ready --warn 50 --crit 75",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_quicksync queue - unack':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_quicksync_queue --state unack --warn 50 --crit 75",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_transmux queue - ready':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_transmux_queue --state ready --warn 100 --crit 150",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_transmux queue - unack':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_transmux_queue --state unack --warn 100 --crit 150",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_vp9 queue - ready':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_vp9_queue --state ready --warn 10 --crit 15",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_vp9 queue - unack':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_vp9_queue --state unack --warn 10 --crit 15",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_event queue - ready':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_transcode_events_queue --state ready --warn 2 --crit 5",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }

  twitch_nrdp::check { 'rabbitmq - hls_event queue - unack':
    command        => "/usr/local/monitor_scripts/check_rabbit_node.py --host ${::fqdn} --check queue --queue worker.hls_transcode_events_queue --state unack --warn 2 --crit 5",
    interval       => 5,
    retry          => 1,
    retry_interval => 2,
  }
}
