# video_setup provides a scaffolding that allows a user to define via hiera a set of exchanges, queues and bindings
class twitch_rabbitmq::video_setup {
  require twitch_rabbitmq

  # First, we need to set up the two exchanges: one for staging, and one for production
  $rabbit_exchanges  = hiera_hash('twitch_rabbitmq::rabbit_exchanges', {})
  $rabbit_queues     = hiera_hash('twitch_rabbitmq::rabbit_queues', {})
  $rabbit_bindings   = hiera_hash('twitch_rabbitmq::rabbit_bindings', {})
  # Define defaults
  $exchange_defaults = {
    'ensure'      => present,
    'type'        => 'direct',
    'auto_delete' => false,
    'durable'     => true,
  }
  $queue_defaults  = {
    'ensure'      => present,
    'durable'     => true,
    'auto_delete' => false,
  }
  $binding_defaults  = {
    'ensure'           => present,
    'destination_type' => 'queue',
    'routing_key'      => '',
  }

  if !empty($rabbit_exchanges) {
    create_resources(rabbitmq_exchange, $rabbit_exchanges, $exchange_defaults)
  }

  if !empty($rabbit_queues) {
    create_resources(rabbitmq_queue, $rabbit_queues, $queue_defaults)
  }

  if !empty($rabbit_bindings) {
    create_resources(rabbitmq_binding, $rabbit_bindings, $binding_defaults)
  }

  Rabbitmq_exchange <| |> -> Rabbitmq_queue <| |> -> Rabbitmq_binding <| |>

}
