class twitch_rabbitmq::video_users inherits twitch_rabbitmq {

  # make the file first?
  file { 'rabbitmq_file':
    ensure => 'present',
    path   => $twitch_rabbitmq::rabbitmq_secret_file,
  }

  twitch_sandstorm_agent::template{ 'jtvtwchmq':
    ensure      => 'present',
    destination => $twitch_rabbitmq::rabbitmq_secret_file,
    mode        => '0600',
    owner       => 'rabbitmq',
    group       => 'rabbitmq',
    contents    => template('twitch_rabbitmq/rabbitmq_management_pw.erb'),
  }

  rabbitmq_user { 'jtvtwchmq':
    ensure    => 'present',
    admin     => true,
    password  => $::rabbit_password,
    subscribe => File[$twitch_rabbitmq::rabbitmq_secret_file],
  }

  rabbitmq_user_permissions { 'jtvtwchmq@/':
    configure_permission => '.*',
    read_permission      => '.*',
    write_permission     => '.*',
  }
}
