class twitch_raymundo (
  $deploy_envs            = $twitch_raymundo::params::deploy_envs,
  $project                = $twitch_raymundo::params::project,
  $deploy_dir             = $twitch_raymundo::params::deploy_dir,
  $app_env                = $twitch_raymundo::params::app_env,
  $app_env_pops_mapping   = $twitch_raymundo::params::app_env_pops_mapping,
  $app_sec_offset         = $twitch_raymundo::params::app_sec_offset,
) inherits twitch_raymundo::params {
  include twitch::packages
  include twitch::users::jtv
  include postgresql::lib::devel

  include twitch_python::pip::ipaddr
  include twitch_python::pip::requests
  include twitch_python::pip::statsd
  include twitch_python::python_git
  include twitch_python::python_postgres

  realize(Package['snmp'])

  case $app_env {
    'production':             { $raymundo_pops = unique($app_env_pops_mapping['main_pops_set']) }
    'canary':                 { $raymundo_pops = unique($app_env_pops_mapping['testing_pops_set']) }
    'production_and_canary':  { $raymundo_pops = unique(concat($app_env_pops_mapping['main_pops_set'], $app_env_pops_mapping['testing_pops_set'])) }
    default:                  { $raymundo_pops = [] }
  }

  consul::service { 'video-raymundo':
    consul_tags  => $deploy_envs,
    service_name => 'video-raymundo'
  }

  courier::install { 'raymundo':
    env     => 'production', # all hosts should deploy prod build on first courier install
    repo    => $project,
    basedir => $deploy_dir,
  }

  daemontools::supervise { $raymundo_pops:
    syslog    => 'local3',
    predaemon => [
      "tw_string=\${PWD##*/}",
      "cluster=\${tw_string#raymundo_}",
      $app_sec_offset,
    ],
    daemon    => "${deploy_dir}/raymundo/current/bin/raymundo -c \$cluster 2>&1",
    wd        => "${deploy_dir}/raymundo/current/bin",
    require   => Courier::Install['raymundo'],
  }
}
