class twitch_raymundo::params {
  $deploy_envs       = ['production']
  $deploy_dir         = '/opt/twitch'
  $project           = 'video/raymundo'
  $app_env           = 'production'

  $app_sec_offset = $::hostname ? {
    'video-raymundo-c55a24' => 'export SECS_OFFSET=0',  # CDG02
    'video-raymundo-a250cc' => 'export SECS_OFFSET=30', # SJC02
    'video-raymundo-8c798c' => 'export SECS_OFFSET=0',  # SJC02 canary
    'video-raymundo-a24998' => 'export SECS_OFFSET=0',  # emergency SJC02, replacing CDG02
    default                 => undef,
  }

  $app_env_pops_mapping  = {
    'main_pops_set'     => [
      'raymundo_ams02',
      'raymundo_arn03',
      'raymundo_atl01',
      'raymundo_cdg02',
      'raymundo_den01',
      'raymundo_dfw02',
      'raymundo_fra02',
      'raymundo_fra05',
      'raymundo_fra06',
      'raymundo_hel01',
      'raymundo_hkg01',
      'raymundo_jfk04',
      'raymundo_jfk06',
      'raymundo_lax03',
      'raymundo_lhr03',
      'raymundo_mia02',
      'raymundo_mil01',
      'raymundo_ord02',
      'raymundo_osl01',
      'raymundo_phx01',
      'raymundo_sea01',
      'raymundo_sel01',
      'raymundo_sel03',
      'raymundo_sin01',
      'raymundo_syd01',
      'raymundo_tyo01',
      'raymundo_waw01',
      'raymundo_yto01',
      'raymundo_mad01',
      'raymundo_iad03',
      'raymundo_vie01',
      'raymundo_qro01',
      'raymundo_sao01',
      'raymundo_rio01',
      'raymundo_tpe01',
      'raymundo_ymq01',
      'raymundo_pdx01',
      'raymundo_sjc02',
      'raymundo_ber01',
      'raymundo_prg02',
      'raymundo_slc01',
      'raymundo_cph01',
    ],
    'testing_pops_set'         => [
      'raymundo_mrs01',
      'raymundo_hou01',
    ],
  }
}
