# == Class: twitch_redis
#
# Install redis.
class twitch_redis (
  $ensure          = $twitch_redis::params::ensure,
  $version         = $twitch_redis::params::redis_version,
) inherits twitch_redis::params {

  # if we want absent ensure, we use it here
  $package_ensure = $ensure ? {
    'absent' => 'absent',
    default  => $version,
  }

  # installs all base directories and init scripts
  $redis_packages = ['redis-server', 'redis-tools']

  package { $redis_packages:
    ensure  => $package_ensure,
  }

  # Ensure unattended-upgrades to not yolo upgrade packages
  $apt_ensure = $ensure ? {
    absent  => 'absent',
    default => 'present',
  }

  apt::pin { 'redis-packages':
    ensure   => $apt_ensure,
    packages => $redis_packages,
    priority => 600,
    version  => $package_ensure,
  }

  # this is because the package installs a default daemon
  # since its unconfigured by puppet, we ensure its stopped
  service { 'redis-server':
    ensure    => 'stopped',
    enable    => false,
    hasstatus => true,
    require   => Package['redis-server']
  }

  # because we don't manage the default config file, lets remove it
  # to ensure we cannot start it manually/accidentally
  file { $default_conf_file:
    ensure  => 'absent',
    require => Service['redis-server'],
  }

}
