class twitch_redis::metrics (
  $metrics_config = $twitch_redis::params::metrics_config,
) inherits twitch_redis::params {
  include twitch_diamond
  require twitch_python::pip::redis

  concat { $metrics_config:
    ensure  => $ensure,
    require => Class['twitch_diamond::config'],
    notify  => Class['twitch_diamond::service'],
  }

  if $ensure == 'present' {
    concat::fragment { 'diamond-redis-preamble':
      target  => $metrics_config,
      content => template("${module_name}/diamond/RedisCollector_preamble.conf.erb"),
      order   => '01',
    }
  }
}
