class twitch_redis::params {
  # global variables for entire class to reference
  $redis_conf_dir    = '/etc/redis'
  $default_conf_file = "${redis_conf_dir}/redis.conf"

  case $::lsbdistcodename {
    'precise': {
      $redis_version = "2:3.0.1-rwky1~${::lsbdistcodename}"
    }
    'xenial': {
      $redis_version = "3:3.2.8-1chl1~${::lsbdistcodename}1"
    }
    'bionic': {
      $redis_version = 'present'
    }
    default: {
      fail("twitch_redis does not support $::lsbdiscodename")
    }
  }
  $metrics_config = '/etc/diamond/configs/RedisCollector.conf'
  $ensure = 'present'
}
