define twitch_redis::server_metrics (
  $ensure = 'present',
  $addr   = "localhost:${name}",
) {
  if $ensure == 'present' {
    include twitch_redis::metrics

    concat::fragment { "diamond-twitch_redis-$name":
      target  => $twitch_redis::metrics::metrics_config,
      content => "${name}@${addr}, ",
      order   => '02',
      notify  => Class['twitch_diamond::service'],
    }
  }
}
