# twitch_ruby::config sets config items for ruby (apt?)
class twitch_ruby::config (
  $ruby_package       = $twitch_ruby::params::ruby_package,
  $ruby_use_brightbox = $twitch_ruby::params::ruby_use_brightbox,
) inherits twitch_ruby::params {

  include ::apt

  apt::key { 'brightbox':
    ensure => $ruby_use_brightbox,
    id     => '80F70E11F0F0D5F10CB20E62F5DA5F09C3173AA6',
    before => Apt::Ppa['ppa:brightbox/ruby-ng'],
  }

  # https://launchpad.net/~brightbox/+archive/ubuntu/ruby-ng
  apt::ppa { 'ppa:brightbox/ruby-ng':
    ensure => $ruby_use_brightbox,
  }

  # lets prefer all ruby packages that come out of this PPA
  # ignore others like nginx, and whatever else they put in their PPA
  apt::pin { 'ruby-packages':
    ensure   => $ruby_use_brightbox,
    origin   => 'ppa.launchpad.net',
    priority => 610,
    packages => [
      $ruby_package,
      "${ruby_package}-dev",
      '*ruby*',
    ],
  }
}
