# twitch_ruby Sets up ruby in a twitch specific way
class twitch_ruby(
  $ruby_package  = $twitch_ruby::params::ruby_package,
  $ruby_bin      = $twitch_ruby::params::ruby_bin,
  $rake_ensure   = $twitch_ruby::params::rake_ensure,
  $provider_type = $twitch_ruby::params::provider_type,
) inherits twitch_ruby::params {

  include twitch_ruby::config

  class { '::ruby':
    ruby_package     => $ruby_package,
    rubygems_package => undef,
    latest_release   => true,
    gems_version     => undef,
    require          => Class['twitch_ruby::config'],
  }

  class { '::ruby::dev':
    ruby_dev_packages => ["${ruby_package}-dev"],
    rake_provider     => $provider_type,
    bundler_provider  => $provider_type,
    rake_ensure       => $rake_ensure,
  }

  # req'd for ruby-shadow
  package { 'libgmp-dev':
    ensure  => installed,
    require => Class['::ruby::dev'],
  }

  # gem to enable password shadow management via puppet
  package { 'ruby-shadow':
    ensure   => installed,
    provider => 'gem',
    require  => Package['libgmp-dev'],
  }

  # required for bionic else some puppet modules may fail
  if versioncmp($::lsbmajdistrelease, '18.04') >= 0 {
    file { '/usr/local/bin/ruby':
      ensure => link,
      target => $ruby_bin,
    }
    # TODO this is a temporary workaround and should be removed when
    # preseed will be updated to install ruby-shadow as part of the firstboot
    # and all existing bionic hosts will get ruby-shadow installed
    exec { 'install-ruby-shadow':
      unless  => '/opt/omnibus-puppet/embedded/bin/gem list|grep -q ^ruby-shadow',
      command => '/opt/omnibus-puppet/embedded/bin/gem install ruby-shadow',
    }
  }

  # helper to order gem provided packages
  # we here exclude the gems that the OSS module declares in the ordering
  Class['::ruby', '::ruby::dev']
  -> Package <| provider == 'gem' and tag != 'virtual' and title != 'bundler' and title != 'rake' |>
}
