class twitch_sandstorm::config inherits twitch_sandstorm {

  # Create the sandstorm group
  group { $sandstorm_group:
    ensure => 'present',
    system => true,
  }

  # Create the sandstorm user
  user { $sandstorm_user:
    ensure     => 'present',
    home       => $sandstorm_home,
    managehome => false,
    forcelocal => true,
    system     => true,
    gid        => $sandstorm_group,
    require    => [
      Group[$sandstorm_group],
    ],
  }

  file { $config_dir:
    ensure  => directory,
    owner   => $sandstorm_user,
    group   => $sandstorm_group,
    require => [
      User[$sandstorm_user],
    ],
  }

  twitch_sandstorm_agent::template { "config_file":
    destination     => $config_file,
    restart_command => "${sandstorm_dir}/courier/restart.sh",
    owner           => $sandstorm_user,
    group           => $sandstorm_group,
    mode            => '0444',
    contents        => template("${module_name}/sandstorm.hcl.erb"),
    require => [
      File[$config_dir],
    ],
  }
}
