class twitch_sandstorm::service inherits twitch_sandstorm {
  # Consul service
  consul::service { "sandstorm":
    port           => '80',
    consul_tags    => [$sandstorm_environment],
  }

  # configure daemontools to run self-service-dns
  daemontools::supervise { 'sandstorm-server':
    wd         => $sandstorm_dir,
    daemon     => "${sandstorm_dir}/sandstorm/sandstorm-server",
    options    => "-config=${config_file} 2>&1",
    syslog     => 'local3',
    down       => false,
    daemon_dir => '/etc/service',
    user       => $sandstorm_user,
  }

  courier::install{ 'sandstorm':
    env  => $sandstorm_environment,
    repo => 'systems/sandstorm',
  }

  #filebeat logging
  ::filebeat::prospector { 'sandstorm':
  paths    => [
    '/var/log/jtv/sandstorm-server.json.log',
  ],
  doc_type => 'sandstorm',
  fields   => {
    'output' => 'syslog_elasticsearch',
  }
}
}
