#Sandstorm Agent

To learn more about the sandstorm-agent, see here https://git-aws.internal.justin.tv/systems/sandstorm-agent.

To see FAQs and other information/how tos, see https://twitchtv.atlassian.net/wiki/display/SYS/Sandstorm%3A+Secret+Management+System.

## Agent Configuration Overrides in Hiera
The following attributes are available to be overridden in hiera. 
### Fields

Below are a list of attributes that can be used to override sandstorm-agent's default values.

Override them with `twitch_sandstorm_agent::<$attribute_name>`

Attribute   | Description
----------- | -------------
`$dwell`       | Minimum time in seconds to wait for additional updates before performing any actions.
`$splay`       | Ceiling of interval [0-N] seconds to randomly wait before a post-update service restart.
`$role`       | Not yet implemented, but will be used for grouping secrets together.
`$topic_arn`    | The topic that your queue should listen on.
`$table_name`   | The DynamoDB table to fetch secrets from.
`$key_id`       | A KMS KeyId, either a key alias prefixed by 'alias/', a key ARN, or a key UUID.
`$role_arn`     | An IAM Role ARN if assuming a role in different AWS account.
`$port`         | Port for health check to run on.
`$pid_path`     | File name for pid file (should not really change)
`$pop`          | Name of your pop (will take this from facter by default)
`$use_squid_proxy`    | Sets sandstorm to use squid proxy as fallback
`$proxy`        | Will default to squid proxy if use_proxy set
`$backoff_multiplier`     | Exponential backoff multiplier
`$max_wait_time`     | Max wait time when backing off
`$use_milliner`      | use milliner-\$role-\$env-\$pop as \$role_arn instead of default and source milliner env vars.

## Template Configuration

Set template attributes as follows in manifests

```
twitch_sandstorm_agent::template { 'wildcard-jtv-cert':
   destination => '/tmp/test-cert',
   key         => 'WILDCARD_INTERNAL_JUSTIN_TV_CERT',
}
```

or in hiera

```
sandstorm_keys:
  "test_template":
      destination: '/etc/sandstorm-agent/output/sample_output'
      key: systems/sandstorm-agent/development/test_secret
```

### General Fields
Attribute   | Description
----------- | -------------
`$ensure` | "present", "absent", state of managed resources
`$dwell`       | "present", "absent", state of managed resources
`$destination` | The path where the final file should be placed
`$restart_command` | Shell command to run which restarts the service that depends on the destination file.
`$owner` | owner of the destination file - default to root if not set
`$group` | group of the destination file - defaults to root if not set
`$mode ` | mode of the destination file - defaults to 0644 if not set
`$trim_newline` | trims the trainling newline in destination file it set to true
`$delete_dest` | Boolean, whether or not to delete the destination file when ensure = absent on this resource. Has no effect when ensure = present. Defaults to false.

### Template Source Configuration
Use either `contents` OR `key` OR `template`, OR `file` OR `source`. Do not use more than one.

Attribute   | Description
----------- | -------------
`$contents` | String, the contents of the template file to be used. 
`$key` | String, the secret key that should be placed into the destination file. Use this when a file should only contain a single secret and nothing else.
`$template` | Puppet template to be passed in as the source
`$source` | If you ship your sandstorm templates in your source code, set this to be the path to that file
`$file` | A file to be used as a Sandstorm template ({module_name}/files/cert.erb)
`$allow_empty` | Allows template source to be blank


Should I Use *template* or *template_composite*?
===========

`twitch_sandstorm_agent::template` is a sandstorm define which allows you to specify a file to be managed by sandstorm 
 and have secrets injected into it.  You should use `template` in cases when have a single corpus of text that needs
 to have secrets injected into it.

`twitch_sandstorm_agent::template_composite` is a blank slate which can have fragments of text concatenated to it
 by defining `twitch_sandstorm_agent::template_fragment` resources.  The final assembled file will have sandstorm
 secrets injected into it. You should use `template_composite` and `template_fragment` when you have several small
 corpuses of text that need to occupy the same file, which should then have secrets injected into it.
