class twitch_sandstorm_agent::config inherits twitch_sandstorm_agent {

  if $pop == undef {
    $pop = 'undefined'
  }

  if !$use_squid_proxy {
    $proxy = 'none'
  }

  file { $config_dir:
    ensure => directory,
  }

  file { $confd_dir:
    ensure  => directory,
    purge   => true,
    recurse => true,
  }

  file { $templates_dir:
    ensure  => directory,
    require => [
      File[$config_dir],
    ],
    purge   => true,
    notify  => [
      Class['twitch_sandstorm_agent::service'],
    ],
    recurse => true,
  }

  file { $env_dir:
    ensure  => directory,
    owner   => root,
    group   => root,
    mode    => '0555',
    require => [
      File[$config_dir],
    ],
  }

  # this is a hack to use a ~/.aws/credentials file until we figure out IAM
  file {"${env_dir}/HOME":
    ensure  => present,
    require => File[$env_dir],
    content => template("${module_name}/env_home.erb"),
  }

  # Remove old single-file config so we can replace it with the new thing.
  file { $old_config_file:
    ensure => 'absent',
  }

  $short_twitch_env = $::twitch_environment ? {
    'production'  => 'prod',
    'staging'     => 'staging',
    'development' => 'dev',
    default       => 'prod',
  }

  if ($twitch_sandstorm_agent::use_milliner) and ($twitch_sandstorm_agent::role_arn == 'default') {
    $real_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/milliner-${twitch_role}-${short_twitch_env}-${pop}"
  } else {
    $real_role_arn = $twitch_sandstorm_agent::role_arn
  }

  file { $config_file:
    ensure  => present,
    content => template("${module_name}/config.erb"),
    require => File[$old_config_file],
    notify  => [
      Class['twitch_sandstorm_agent::service'],
    ],
  }

}
