# This Class installs the Sandstorm Agent Service.
# On Xenial and CentOS: A systemd service unit file is installed by the package,
# so this manifest just makes sure the service is running and enabled.
# On Precise & non-systemd: Monit is installed and used to control the service.
#
class twitch_sandstorm_agent::service inherits twitch_sandstorm_agent {
  if str2bool($::systemd) {
    service { 'sandstorm-agent':
      ensure => 'running',
      enable => true,
      # This does not change the cli service or systemctl restart command.
      # This allows puppet to reload sandstorm when a new template is placed.
    }
    # twitch_systemd::dropin does not work with twitch_cosmos
    # using an explicit dumb File resource instead
    if $twitch_sandstorm_agent::use_milliner {
      $ensure_dir      = 'directory'
      $ensure_override = 'present'
    } else {
      $ensure_dir      = 'absent'
      $ensure_override = 'absent'
    }
    file { '/etc/systemd/system/sandstorm-agent.service.d':
      ensure  => $ensure_dir,
      force   => true,
      purge   => true,
    }
    file { '/etc/systemd/system/sandstorm-agent.service.d/sandstorm-agent-millener-env.conf':
      ensure  => $ensure_override,
      source  => 'puppet:///modules/twitch_sandstorm_agent/millener-env.conf',
      require => File['/etc/systemd/system/sandstorm-agent.service.d'],
      notify  => Exec["${name}-systemd-reload"],
    }
    exec {"${name}-systemd-reload":
      command     => 'systemctl daemon-reload',
      refreshonly => true,
      notify      => Service['sandstorm-agent'],
    }
  } else {
    service { 'monit-sandstorm-agent':
      ensure    => 'running',
      provider  => 'base',
      hasstatus => false,
      start     => '/usr/bin/monit start sandstorm-agent',
      status    => 'kill -0 $(cat /var/run/sandstorm-agent.pid)',
      stop      => '/usr/bin/monit stop sandstorm-agent',
    }
  }
}
