# define: twitch_sandstorm_agent::template_fragment
#
# Concats into a puppet-managed template_composite file
#
# Parameters:
#   [*ensure*]          - "present", "absent", state of managed resources
#   [*template*]        - The name of the template_composite to add to.
#   [*contents*]        - String, the contents of the template file to be used.
#   [*order*]           - String, ordering key indicating the order different fragments should be added
#
# Usage:
#  twitch_sandstorm_agent::template_fragment { 'wildcard-jtv-cert-line':
#    template => 'wildcard-jtv-cert',
#    contents => template("${module_name}/cert_line.erb"),
#  }
#

define twitch_sandstorm_agent::template_fragment (
  $contents,
  $template,
  $ensure = 'present',
  $order = '150',
) {
    include twitch_sandstorm_agent

    $template_source = "${twitch_sandstorm_agent::params::templates_dir}/${template}"

    concat::fragment { "sandstorm_fragment_${template}_${name}":
      target  => $template_source,
      content => $contents,
      order   => $order
    }
}
