# Define passive service checks.
#
define twitch_servicecheck::passive (
  $command,
  $ensure         = 'present',
  $interval       = undef,
  $retry_interval = undef,
  $retry          = undef,
  $timeout        = undef,
  $options        = undef,
  $handler        = undef,
  $user           = undef,
) {
  include twitch_servicecheck
  if $twitch_servicecheck::legacy {
    # nrdp does not support $user, so use sudo instead.
    $_command = $user ? {
      nagios  => $command,
      undef   => $command,
      default => "sudo ${command}",
    }
    twitch_nrdp::check { $name:
      ensure         => $ensure,
      command        => $_command,
      interval       => $interval,
      retry          => $retry,
      retry_interval => $retry_interval,
      cmd_timeout    => $timeout,
      options        => $options,
    }
  } else {
    twitch_nrdc::servicecheck { $name:
      ensure         => $ensure,
      command        => $command,
      interval       => $interval,
      retry          => $retry,
      retry_interval => $retry_interval,
      timeout        => $timeout,
      options        => $options,
      handler        => $handler,
      user           => $user,
    }
  }
}
