#!/usr/bin/env python
#
# SOMEDAY/TODO:
#   * dynamic weight list
#     - so to "warm" up ips
#   * config file

import SocketServer
import argparse
import random
import os
import simplejson as json
import syslog

smtp_list = ['smtp']

class MyTCPServer(SocketServer.ThreadingTCPServer):
    allow_reuse_address = True

class MyTCPServerHandler(SocketServer.BaseRequestHandler):
    def handle(self):
        while True:
            picked = '200 ' + random.choice(smtp_list) + '\n'
            data = self.request.recv(1024)
            try:
                self.request.send(picked)
            except:
                return
            if args.verbose:
                syslog.syslog('request: \'%s\', smtp_transport: %s' % (data, picked))


def these_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-c','--config', action="store", default='/etc/postfix/interfaces.conf')
    parser.add_argument('-v','--verbose', action="store_true")
    parser.add_argument('-b','--bind', action="store", default='127.0.0.1')
    parser.add_argument('-p','--port', action="store", type=int, default=10123)
    return parser.parse_args()
    

def main(args):

    host = args.bind
    port = args.port
    interfaces_config = args.config
    
    if args.verbose:
        syslog.openlog('postfix/balancer',logoption=syslog.LOG_PID, facility=syslog.LOG_MAIL)
    
    try:
        interfaces_file = open(interfaces_config)
    except:
        print "problem opening config files"
        os._exit(1)
    
    interfaces = json.load(interfaces_file)
    
    for item in interfaces['interfaces']:
        smtp_list.append(str(item))
    
    if args.verbose:
        syslog.syslog('smtp_list = %s' % smtp_list)

    server = MyTCPServer((host, port), MyTCPServerHandler)
    try:
        server.serve_forever()
    except KeyboardInterrupt:
        os._exit(1)

if __name__ == "__main__":
    args = these_args()
    main(args)
