# Anycast configuration for twitch_smtp module
class twitch_smtp::anycast {
  include twitch_smtp
  if !$::disable_anycast and $twitch_smtp::anycast_ipaddress {
    include bird::monitoring
    include twitch_anycast_health_enforcer::monitoring
    validate_integer($twitch_smtp::bgp_community)
    twitch_anycast_health_enforcer::service { 'smtp':
      interval   => '2s',
      window     => 4,
      threshold  => 2,
      healthy    => 'all',
      addresses  => [$twitch_smtp::anycast_ipaddress],
      community  => $twitch_smtp::bgp_community,
      flap_limit => -1,
      checks     => {
        "/usr/lib/nagios/plugins/check_tcp -H 127.0.0.1 -p 25 -s QUIT -e '220 smtp-out.justin.tv ESMTP'" => {
          type    => 'cmd',
          timeout => '4s',
        },
      },
    }
  }
}
