# Removes sendmail, installs postfix and mutt.
#
class twitch_smtp::common {

  $sendmail_pkgs = [
    'sendmail',
    'sendmail-cf',
    'sendmail-base',
    'sendmail-bin',
  ]

  package{ $sendmail_pkgs:
    ensure => absent,
  }

  core::util::debconf{ 'postfix_no_conf':
    package => 'postfix',
    key     => 'postfix/main_mailer_type',
    type    => 'select',
    value   => 'No configuration',
  }

  package{ 'postfix':
    ensure  => installed,
    require => [
      Package[$sendmail_pkgs],
      Core::Util::Debconf['postfix_no_conf'],
    ],
  }

  # the package places this, but since we want to manage rsyslog.d, we want to explicitly manage the contents here.
  ::rsyslog::snippet { 'postfix':
    content => "# Create an additional socket in postfix's chroot in order not to break\n# mail logging when rsyslog is restarted.  If the directory is missing,\n# rsyslog will silently skip creating the socket.\n\$AddUnixListenSocket /var/spool/postfix/dev/log\n"
  }

  package{ 'mutt':
    ensure => installed
  }
}
