# Setup steps for flat relay that must exist before the postfix service is first started
#
class twitch_smtp::flat_relay::setup {
  require twitch_smtp::common

  file { '/dev/shm/postfix':
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
  }->
  file { '/etc/aliases':
    ensure => file,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => 'puppet:///modules/twitch_smtp/aliases-server',
  }~>
  # newaliases requires /dev/shm/postfix
  exec { 'newaliases':
    command     => '/usr/bin/newaliases',
    refreshonly => true,
  }->
  file { '/etc/postfix/transport':
    ensure  => file,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => '',
  }~>
  exec { 'postmap_transport':
    command     => '/usr/sbin/postmap /etc/postfix/transport',
    refreshonly => true,
  }->
  file { '/etc/postfix/access':
    ensure  => file,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => '',
  }~>
  exec { 'postmap_access':
    command     => '/usr/sbin/postmap /etc/postfix/access',
    refreshonly => true,
    notify      => Class['twitch_smtp::service'],
  }

}
