# Sets up postfix for clients or servers.
#
class twitch_smtp (
  $anycast              = $twitch_smtp::params::anycast,
  $anycast_ipaddress    = $twitch_smtp::params::anycast_ipaddress,
  $type                 = $twitch_smtp::params::type,
  $impersonate_hostname = $twitch_smtp::params::impersonate_hostname,
  $bgp_community        = $twitch_smtp::params::bgp_community,
) inherits twitch_smtp::params {

  validate_re($type, '^(client|flat_relay)$')

  include "twitch_smtp::${type}"

  file { '/etc/mailname':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "${fqdn}\n",
  }
}
