# Includes monitoring directives for postfix service.
# Starts the postfix service through inheritance.
#
class twitch_smtp::monitoring {
  include twitch_smtp::service # because what else are we monitoring?

  twitch_servicecheck::passive { 'postfix-running':
    command => 'check_procs -C master -u root -c 1:1',
  }
  twitch_servicecheck::passive { 'postfix-smtpd':
    command => 'check_procs -C smtpd -a smtp -u postfix -w 1:200 -c 1:400',
    options => {
      contact_groups => 'systems_pagerduty_low_pri',
    },
  }
  twitch_servicecheck::passive { 'postfix-queue':
    command => 'check-postfix-queue.sh',
  }
}
