# Installs postfix stats script to feed metrics to consumers
#
class twitch_smtp::stats {

  file { '/usr/local/bin/postfix_stats.py':
    owner  => 'root',
    group  => 'root',
    source => 'puppet:///modules/twitch_smtp/stats/postfix_stats.py',
    mode   => '0555',
  }

  file { '/usr/local/bin/postfix_stats.sh':
    owner  => 'root',
    group  => 'root',
    source => 'puppet:///modules/twitch_smtp/stats/postfix_stats.sh',
    mode   => '0555',
  }

  if str2bool($::systemd) {
    twitch_systemd::service { 'postfix_stats':
      command   => '/usr/local/bin/postfix_stats.sh',
      user      => 'root',
      subscribe => File['/usr/local/bin/postfix_stats.sh'],
      restart   => 'always',
    }
  } else {
    daemontools::supervise { 'postfix_stats':
      syslog    => local3,
      wd        => '/tmp/',
      daemon    => 'setsid /usr/local/bin/postfix_stats.sh 2>&1',
      subscribe => File['/usr/local/bin/postfix_stats.sh'],
    }
  }
}
