require 'facter'
require 'facter/util/file_read'

Facter.add('squid_workers') do
  setcode do
    squid_conf = '/etc/squid/squid.conf'
    workers = 1 # workers defaults to 1, aka 'no SMP'
    if File.exists?(squid_conf)
      # attempt to read config file for workers configuration
      if n = Facter::Util::FileRead.read(squid_conf).match(/^workers\s+(\d+)/)
        workers = n[1].to_i
      end
    end
    workers
  end
end
