# Anycast configuration for twitch_squid module
class twitch_squid::anycast (
  $ip        = $twitch_squid::params::anycast_ip,
  $community = $twitch_squid::params::community,
  $port      = $twitch_squid::params::port,
) inherits twitch_squid {

  if (!$::disable_anycast) and ($ip != undef) {
    include bird::monitoring
    include twitch_anycast_health_enforcer::monitoring
    validate_integer($community)
    twitch_anycast_health_enforcer::service { 'squid':
      interval   => '2s',
      rise       => 2,
      fall       => 2,
      healthy    => 'any',
      addresses  => [$ip],
      community  => $community,
      checks     => {
        '/usr/lib/twitch/monitoring-plugins/check-http-proxy --proxy=http://127.0.0.1:9797 --url=http://public-http-test-endpoint.twitch.tv/index.html -s 200' => {
          type    => 'cmd',
          timeout => '4s',
        },
        '/usr/lib/twitch/monitoring-plugins/check-http-proxy --proxy=http://127.0.0.1:9797 --url=https://static.twitchcdn.net/ -s 404,200'                     => {
          type    => 'cmd',
          timeout => '4s',
        },
      },
      service_port => $port,
    }
  }
}
