# handles cache_peer configuration
# either with consul_template, or
# the current override approach which uses a consul lookup in puppet
class twitch_squid::cache_peers inherits twitch_squid {

  if $::twitch_squid::no_direct_connect {
    $template = "${::twitch_squid::squid_config_dir}/cache_peers.conf.ctmpl"
    $output   = "${::twitch_squid::squid_config_dir}/cache_peers.conf.unverified"
    $config   = "${::twitch_squid::squid_config_dir}/cache_peers.conf"

    file { $template:
      ensure  => present,
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => template("${module_name}/cache_peers.conf.ctmpl.erb"),
    }

    file { $config:
      ensure => present,
    }

    consul_template::service { 'squid_cache_peers':
      ensure      => present,
      source      => $template,
      destination => $output,
      command     => "/usr/local/bin/squid-validate-reload.sh ${output} ${config}",
      auto_gen    => true,
    }

    file { '/usr/local/bin/squid-validate-reload.sh':
      ensure  => present,
      owner   => 'root',
      group   => 'root',
      mode    => '0755',
      content => template("${module_name}/squid-validate-reload.sh.erb"),
    }
  }
}
