# twich_squid configuration class
class twitch_squid::config inherits twitch_squid {

  include twitch_vars

  $twitch_networks = $::twitch_vars::twitch_networks

  file { $::twitch_squid::squid_config:
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    notify  => $::twitch_squid::_config_notify,
    require => Package[$::twitch_squid::squid_name],
    content => template("${module_name}/squid.conf.erb"),
  }

  file { $::twitch_squid::cache_dir:
    ensure  => 'directory',
    owner   => $::twitch_squid::squid_user,
    group   => $::twitch_squid::squid_group,
    mode    => '0755',
    require => Package[$::twitch_squid::squid_name],
  }

  # Override options 
  twitch_systemd::drop_in { 'squid-overrides.conf':
    unit    => 'squid.service',
    content => template("${module_name}/squid.systemd.dropin.erb"),
    notify  => Class['::twitch_squid::service'],
  }

  # Decide whether to configure log sampling for squid
  $_squid_use_syslog = $twitch_squid::squid_use_syslog ? {
    true  => 'present',
    false => 'absent',
  }
  # configure syslog snippet
  rsyslog::snippet{ '10-squid-access-log':
    ensure  => $_squid_use_syslog,
    content => template("${module_name}/rsyslog_squid.erb")
  }

  # conditionally configure cw logfile. Requires syslog to be configured.
  $_squid_cw = $twitch_squid::squid_cw ? {
    true  => 'present',
    false => 'absent',
  }
  # decide whether to use the sample log or the syslog log
  $_squid_cw_logfile = $twitch_squid::squid_sample ? {
    true  => $twitch_squid::squid_sample_log,
    false => $twitch_squid::squid_syslog_log_name,
  }
  video_cloudwatch::logfile { 'squid-access':
    ensure    => $_squid_cw,
    file_path => $_squid_cw_logfile,
  }

}
