# twich_squid extra configuration class
# Sets up consul
class twitch_squid::extras inherits twitch_squid {

  if (!$::twitch_squid::no_direct_connect) {
    $egress = 'egress' # used to announce we can proxy out
  }

  consul::service { $::twitch_squid::consul_service:
    port        => $::twitch_squid::port,
    consul_tags => delete_undef_values([
      $::twitch_squid::consul_tags,
      $::default_region,
      $egress,
      $cluster,
      pick($::twitch_environment, $twitch_environment, 'production'),
    ]),
  }

  ::rsyslog::snippet { '45-squid-central':
    ensure  => 'absent',
    content => '',
  }

  if $::twitch_squid::consul_health_checks {
    # append to/override these parameters for the resource defined above
    # we use the envoy-check to check the health of the anycast-health-enforcer,
    # and only listen to squids state, rather than the global state of all services
    Consul::Service[$::twitch_squid::consul_service] {
      check_interval => '5s',
      check_script   => 'envoy-check --port 41537 --state squid',
    }
  }

}
