# Squid installation class
class twitch_squid::install {
  include twitch_squid

  package { $::twitch_squid::squid_name:
    ensure => $::twitch_squid::squid_version,
  }

  $apt_ensure = $::twitch_squid::squid_version ? {
    'absent'    => 'absent',
    'installed' => 'absent',
    default     => 'present',
  }

  apt::pin { $twitch_squid::squid_name:
    ensure   => $apt_ensure,
    packages => $twitch_squid::squid_name,
    priority => 600,
    version  => $::twitch_squid::squid_version,
  }
}
