# twitch_squid parameters class
class twitch_squid::params {
  $parent_proxy_options     = 'no-digest no-query no-netdb-exchange round-robin'
  $egress_local_dc_only     = false
  $cache_refresh_patterns   = []
  $cache_dir                = '/var/cache/squid'
  $consul_service           = 'squid-proxy'
  $consul_health_checks     = false
  #on disk cacheing does not work on smp
  #leave at 1 for the cacheing layer
  $workers                  = 1
  $no_direct_connect        = str2bool($facts['proxy_needed'])
  $anycast_ip               = undef
  $community                = 16009
  $consul_tags              = []

  case $facts['lsbdistcodename'] {
    'xenial': {
      $squid_name    = 'squid'
      $squid_version = '3.5.23-1'
    }
    default: {
      $squid_name    = 'squid'
      $squid_version = 'installed'
    }
  }

  $squid_user            = 'proxy'
  $squid_group           = 'proxy'
  $squid_config_dir      = "/etc/${squid_name}"
  # XXX: squid_config path is hardcoded inside the 'squid_workers' fact included in this module
  $squid_config          = "${squid_config_dir}/squid.conf"

  # config if using squid's default logging
  $squid_use_syslog      = false
  # settings if use_syslog is false
  $squid_log_loc         = "/var/log/${squid_name}/access.log"
  # setting if use_syslog is true
  $squid_syslog_log_fac  = 'local3'
  $squid_syslog_log_lev  = 'info'
  $squid_syslog_log_name = '/var/log/jtv/squid-access.log'

  # sampling config
  $squid_sample          = false
  $squid_sample_log      = '/var/log/jtv/squid-access-sample.log'
  $squid_sampling_rate   = 1  # sampling rate value / 100

  # whether or not to log to cloudwatch
  $squid_cw              = false

  # use custom log format? see config template.
  $squid_log_format_name = 'squid'

  $squid_coredump_loc    = "/var/spool/${squid_name}"
  $port                  = 3128
  if versioncmp($facts['lsbdistrelease'], '16.04') < 0 {
    fail("Release unsupported: ${facts['lsbdistcodename']}")
  }
}
