# Wraps the puppetlabs ssh module
# Writes ssh_client config
class twitch_ssh::client (
  $ensure               = $twitch_ssh::params::ssh_client_ensure,
  $client_options       = $twitch_ssh::params::ssh_client_options,
  $storeconfigs_enabled = $twitch_ssh::params::ssh_client_storeconfigs_enabled,
) inherits twitch_ssh::params {

  validate_string($ensure)
  validate_hash($client_options)
  validate_bool($storeconfigs_enabled)

  class{ '::ssh::client':
    ensure               => $ensure,
    storeconfigs_enabled => $storeconfigs_enabled,
    options              => $client_options
  }
}
