# Default setup client and server
class twitch_ssh {
  include twitch_ssh::client
  include twitch_ssh::server

  # Netboot only
  if $::cmdline['boot'] == 'live' or $::packer_build_name {
    systemd::service {'regenerate_ssh_host_keys':
      description  => 'Regenerate SSH host keys',
      before_units => ['ssh.service'],
      execstartpre => '-/bin/sh -c "/bin/rm -f -v /etc/ssh/ssh_host_*_key*"',
      execstart    => '/usr/bin/ssh-keygen -A -v',
      type         => 'oneshot',
      wantedby     => ['multi-user.target'],
    }

    -> service { 'regenerate_ssh_host_keys':
      enable   => true,
    }
  }
}
