# params for ssh server and client
class twitch_ssh::params {
  ### ssh client related params
  $ssh_client_ensure = 'present'
  $ssh_client_storeconfigs_enabled = false
  $ssh_client_options = {
    'Host *'                      => {
      'StrictHostKeyChecking'     => 'no',
      'SendEnv'                   => 'LANG LC_*',
      'HashKnownHosts'            => 'yes',
      'GSSAPIAuthentication'      => 'yes',
      'GSSAPIDelegateCredentials' => 'no',
      'UseRoaming'                => 'no'
    }
  }

  ### ssh server related params
  $ssh_server_ensure = 'present'
  $ssh_server_storeconfigs_enabled = false

  $ssh_server_hostkeys = [
    '/etc/ssh/ssh_host_rsa_key',
    '/etc/ssh/ssh_host_dsa_key',
    '/etc/ssh/ssh_host_ecdsa_key',
  ]

  $ssh_server_options = {
    'PasswordAuthentication'          => 'no',
    'Port'                            => '22',
    'Protocol'                        => '2',
    'HostKey'                         => $ssh_server_hostkeys,
    'UsePrivilegeSeparation'          => 'yes',
    'KeyRegenerationInterval'         => '3600',
    'ServerKeyBits'                   => '1024',
    'SyslogFacility'                  => 'AUTH',
    'LogLevel'                        => 'INFO',
    'LoginGraceTime'                  => '120',
    'PermitRootLogin'                 => 'no',
    'StrictModes'                     => 'yes',
    'RSAAuthentication'               => 'yes',
    'PubkeyAuthentication'            => 'yes',
    'IgnoreRhosts'                    => 'yes',
    'RhostsRSAAuthentication'         => 'no',
    'HostbasedAuthentication'         => 'no',
    'PermitEmptyPasswords'            => 'no',
    'ChallengeResponseAuthentication' => 'no',
    'GSSAPIAuthentication'            => 'no',
    'X11Forwarding'                   => 'yes',
    'X11DisplayOffset'                => '10',
    'PrintMotd'                       => 'no',
    'PrintLastLog'                    => 'yes',
    'TCPKeepAlive'                    => 'yes',
    'UseDNS'                          => 'no',
    'AcceptEnv'                       => 'LANG LC_*',
    'Subsystem'                       => 'sftp /usr/lib/openssh/sftp-server',
    'UsePAM'                          => 'yes',
    'AddressFamily'                   => 'inet',
    'DenyGroups'                      => 'noaccess',
    # lint:ignore:140chars
    'Ciphers'                         => 'aes128-ctr,aes192-ctr,aes256-ctr,aes128-gcm@openssh.com,aes256-gcm@openssh.com,chacha20-poly1305@openssh.com',
    'MACs'                            => 'hmac-sha2-256,hmac-sha2-512,umac-128@openssh.com,hmac-sha2-256-etm@openssh.com,hmac-sha2-512-etm@openssh.com,umac-128-etm@openssh.com',
    'KexAlgorithms'                   => 'ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha1,diffie-hellman-group-exchange-sha256',
  }

}
