# Wraps puppetlabs ssh module
# Sets stuff for ssh server config
class twitch_ssh::server (
  $ensure               = $twitch_ssh::params::ssh_server_ensure,
  $server_options       = $twitch_ssh::params::ssh_server_options,
  $server_options_extra = {},
  $storeconfigs_enabled = $twitch_ssh::params::ssh_server_storeconfigs_enabled,

) inherits twitch_ssh::params {

  validate_string($ensure)
  validate_hash($server_options, $server_options_extra)
  validate_bool($storeconfigs_enabled)

  $ssh_server_options_ldap = {
    'AuthorizedKeysCommand'     => '/usr/bin/sss_ssh_authorizedkeys',
    'AuthorizedKeysCommandUser' => 'nobody',
  }

  $server_options_merged = merge($server_options, $ssh_server_options_ldap, $server_options_extra)

  class{ '::ssh::server':
    ensure               => $ensure,
    storeconfigs_enabled => $storeconfigs_enabled,
    options              => $server_options_merged,
  }

}
