# twitch_ssl_certificate

Wrapper module for placing SSL certificates on puppet. This module:

1. Configures a certificate (and optionally its key). Certificate placement may or may not use sandstorm templating but writing a key requires the machine to run sandstorm (as we do not want to be in the business of hardcoding secrets in git repos).
1. Places monitoring configuration in a deterministic location on the filesystem with a predetermined format so certificate tooling knows which certificates are placed where on disk. There are supported configurations placed for existing nagios checks as well as for future certzero TM tooling.

Note: If using nagios, this will define (if not already defined) a passive check called `SSL_Validation` to report to nagios. If you have multiple certificates configured on your machine class, the wrapper will gracefully handle adding config and the same nagios check will just report the expiration of the N certs you've configured.

Broken out/inspired from twitch::ssl_certificate and twitch_monitor_scripts::ssl_check to decouple from monolithic modules.

## Usage examples

#### Basic cert with a key (I want the legacy nagios config)


```
twitch_ssl_certificate::certificate { 'foo-pop-cert':
  cert_filesystem_path => '/path/to/my/cert/on/disk',
  cert_contents        => '{{ key "my/sandstorm/cert/path" }}',
  cert_restart_cmd     => '/my/service/binary reload',
  key_filesystem_path  => '/path/to/my/key/on/disk',
  key_contents         => '{{ key "my/sandstorm/key/path" }}',
  key_restart_cmd      => '/my/service/binary reload',
}
```

#### Basic cert with a key (please no nagios config)

```
twitch_ssl_certificate::certificate { 'foo-pop-cert':
  monitoring_use_nagios => false,
  cert_filesystem_path  => '/path/to/my/cert/on/disk',
  cert_contents         => '{{ key "my/sandstorm/cert/path" }}',
  cert_restart_cmd      => '/my/service/binary reload',
  key_filesystem_path   => '/path/to/my/key/on/disk',
  key_contents          => '{{ key "my/sandstorm/key/path" }}',
  key_restart_cmd       => '/my/service/binary reload',
}
```

#### Basic cert without key

```
twitch_ssl_certificate::certificate { 'foo-pop-cert':
  monitoring_use_nagios => false,
  cert_filesystem_path  => '/path/to/my/cert/on/disk',
  cert_contents         => '{{ key "my/sandstorm/cert/path" }}',
  cert_restart_cmd      => '/my/service/binary reload',
}
```

#### Basic cert (I don't need sandstorm)

If you're thinking about using this and are not VidCS, you may want to consider consulting VidCS first. IRL example with puppet CA cert:
```
twitch_ssl_certificate::certificate { "${module_name}_${title}":
  require_sandstorm    => false,
  cert_filesystem_path => "${cert_path}/${title}.pem",
  cert_contents        => $file_contents,
  cert_owner           => $user,
  cert_group           => $group,
  cert_mode            => '0644',
  cert_self_signed     => true, # this CA cert happened to be self-signed. Yours may not be!
}
```

#### I have existing sandstorm puppet resources that place certs and keys and want mechanical sympathy 

IRL example with consul-wanmaster and wildcard-jtv:
```
twitch_ssl_certificate::certificate { 'wildcard-jtv-cert':  # name here was the name of the old twitch_sandstorm_agent::template for the cert
  cert_filesystem_path => $cert_file,
  cert_contents        => $wildcard_jtv_cert,
  cert_restart_cmd     => '/usr/sbin/service nginx reload',
  key_identifier       => 'wildcard-jtv-key', # this was the name of the old twitch_sandstorm_agent::template for the cert
  key_filesystem_path  => $key_file,
  key_contents         => $wildcard_jtv_key,
  key_restart_cmd      => '/usr/sbin/service nginx reload',
  before               => Twitch_nginx::Vhost['consul'],
}
```

This makes it so that running puppet won't forcefully purge the old sandstorm resources and recreate them, causing a lot of service reloads and triggers.

### Any Other Questions?

For more details, please refer to the parameters and usage directions in [the defined resource manifest](manifests/certficate.pp).
