# == Class twitch_ssl_certificate::params
#
#  These are the configurable parameters for twitch_ssl_certificate
#
class twitch_ssl_certificate::params {
  # Changing this will have repercussions on OOB tooling (certzero metrics reporter).
  $ensure              = 'present'
  $cert_metadata_path  = '/etc/ssl_validate.conf'
  $certzero_dir        = '/opt/twitch/certzero'
  # Certzero conf options
  $certzero_conf_dir   = "${twitch_ssl_certificate::params::certzero_dir}/conf.d"
  $certzero_bin_dir    = "${twitch_ssl_certificate::params::certzero_dir}/bin"
  # Nagios check options. Decouple SSL checks away from twitch_monitor_scripts
  if $::packer_build_name {
    $enable_nagios_check = false
  } else {
    $enable_nagios_check = true
  }
  $check_interval      = 50
  $check_retry         = 2
  $check_global_opts   = '--ignore-ocsp --warning 3 --critical 1'
  $group               = 'root'
  $owner               = 'root'
}
