class twitch_statsite::install inherits twitch_statsite {
  # We change the pid file because the default location of /var/run/statsite.pid
  # is not writable by unprivileged users, like 'statsite' or 'www-user'.
  $pid_file = '/var/run/statsite/statsite.pid'
  # We have to make the folder to put it in.
  file { '/var/run/statsite':
    ensure => 'directory',
    owner  => 'statsite',
    group  => 'statsite',
    mode   => '0755',
  }
  class { 'statsite':
    version           => '0.7.1',
    graphite_host     => 'graphite-ingest.central.twitch.a2z.com',
    graphite_prefix   => 'stats.',
    extended_counters => 1,
    pid_file          => $pid_file,
    require           => File['/var/run/statsite'],
    log_level         => 'info',
  }
  twitch_monit::check{ 'statsite':
    ensure         => $twitch_statsite::use_monit,
    pidfile        => $pid_file,
    check_interval => 5,
    start_program  => '/etc/init.d/statsite start',
    stop_program   => '/etc/init.d/statsite stop',
    cwd            => '/',
    custom_checks  => [
                        'if failed host 127.0.0.1 port 8125 type tcp then restart',
                        'if 5 restarts within 5 cycles then timeout'
                      ],
    uid            => 'root',
    require        => Class['statsite'],
  }
}
