# configure zookeeper hosts into the storm config
class twitch_storm::config (
  $nimbus_hosts,
) inherits twitch_storm {
  $zookeeper_hosts = consul_service_lookup('zookeeper', {
    'passing' => true,
    'tag' => $::twitch_environment,
    'dc'  => 'us-west2',
  })

  file { $twitch_storm::confdir:
    ensure => directory,
    owner  => $twitch_storm::user,
    group  => $twitch_storm::group,
    mode   => '0644'
  }

  file { "${twitch_storm::confdir}/storm.yaml":
    ensure  => present,
    require => File[$twitch_storm::confdir],
    content => template("${module_name}/storm.yaml.erb"),
    owner   => $twitch_storm::user,
    group   => $twitch_storm::group,
    mode    => '0644'
  }
}
