# install the foundation for a storm nimbus or supervisor host
class twitch_storm::install (
  $mirror   = $twitch_storm::params::mirror,
  $checksum = $twitch_storm::params::checksum,
) inherits twitch_storm {
  require java

  file { $twitch_storm::basedir:
    ensure => directory,
    owner  => $twitch_storm::user,
    group  => $twitch_storm::group,
  }

  file { $twitch_storm::localdir:
    ensure => directory,
    owner  => $twitch_storm::user,
    group  => $twitch_storm::group,
  }

  user { $twitch_storm::user:
    ensure => present,
    gid    => $twitch_storm::group,
  }

  group { $twitch_storm::group:
    ensure => present,
  }

  archive { "/tmp/apache-storm-${twitch_storm::version}.tar.gz":
    ensure        => present,
    extract       => true,
    extract_path  => $twitch_storm::basedir,
    source        => "${mirror}/apache-storm-${twitch_storm::version}/apache-storm-${twitch_storm::version}.tar.gz",
    checksum      => downcase($checksum),
    checksum_type => 'md5',
    creates       => "${twitch_storm::basedir}/apache-storm-${twitch_storm::version}/lib/storm-core-${twitch_storm::version}.jar",
  }

  file { '/var/log/storm':
    ensure => directory,
    owner  => $twitch_storm::user,
    group  => $twitch_storm::group,
    mode   => '0644'
  }
}
