# install and run the nimbus process to manage supervisor hosts
class twitch_storm::nimbus inherits twitch_storm {
  consul::service { 'storm-nimbus':
    consul_tags    => [$::twitch_environment],
  }

  $nimbus_hosts = consul_service_lookup('storm-nimbus', {
    'passing' => true,
    'tag' => $::twitch_environment,
    'dc'  => 'us-west2',
  })

  class { 'twitch_storm::config':
    nimbus_hosts => concat($nimbus_hosts, {'ip' => $::ipaddress})
  }

  daemontools::supervise { 'storm-nimbus':
    daemon_dir     => '/var/lib/service',
    user           => $twitch_storm::user,
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => "${twitch_storm::basedir}/apache-storm-${twitch_storm::version}",
    daemon         => 'bin/storm nimbus 2>&1',
    predaemon      => [
      "export STORM_CONF_DIR=${twitch_storm::confdir}",
    ]
  }

  file { "${twitch_storm::localdir}/nimbus":
    ensure => directory,
    owner  => $twitch_storm::user,
    group  => $twitch_storm::group,
    mode   => '0644'
  }
}
