# install and run the supervisor process to execute storm topologies
class twitch_storm::supervisor inherits twitch_storm {
  class { 'twitch_storm::config':
    nimbus_hosts => consul_service_lookup('storm-nimbus', {
      'passing' => true,
      'tag'     => $::twitch_environment,
      'dc'      => 'us-west2',
    })
  }

  daemontools::supervise { 'storm-supervisor':
    daemon_dir     => '/var/lib/service',
    user           => $twitch_storm::user,
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => "${twitch_storm::basedir}/apache-storm-${twitch_storm::version}",
    daemon         => 'bin/storm supervisor 2>&1',
    predaemon      => [
      "export STORM_CONF_DIR=${twitch_storm::confdir}",
    ]
  }

  daemontools::supervise { 'storm-logviewer':
    daemon_dir     => '/var/lib/service',
    user           => $twitch_storm::user,
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => "${twitch_storm::basedir}/apache-storm-${twitch_storm::version}",
    daemon         => 'bin/storm logviewer 2>&1',
    predaemon      => [
      "export STORM_CONF_DIR=${twitch_storm::confdir}",
    ]
  }

  file { "${twitch_storm::localdir}/supervisor":
    ensure => directory,
    owner  => $twitch_storm::user,
    group  => $twitch_storm::group,
    mode   => '0644'
  }
}
