# run the UI process to visualize the state of a storm cluster
class twitch_storm::ui inherits twitch_storm {
  daemontools::supervise { 'storm-ui':
    daemon_dir     => '/var/lib/service',
    user           => $twitch_storm::user,
    syslog         => 'local3',
    enable_cgroups => true,
    wd             => "${twitch_storm::basedir}/apache-storm-${twitch_storm::version}",
    daemon         => 'bin/storm ui 2>&1',
    predaemon      => [
      "export STORM_CONF_DIR=${twitch_storm::confdir}",
    ]
  }
}
