class twitch_streamloader (
  $ensure                    = $twitch_streamloader::params::ensure,
  $env                       = $twitch_streamloader::params::env,
  $user                      = $twitch_streamloader::params::user,
  $binary                    = $twitch_streamloader::params::binary,
  $log_dir                   = $twitch_streamloader::params::log_dir,
) inherits twitch_streamloader::params {
  validate_string($env, $user, $log_dir) 
  validate_re($binary, '^streamloader_(relay|media)$', 'The value for binary must be either "streamloader_relay" or "streamloader_media"')

  $consul_tags = [$env, "${binary}_${env}"]

  twitch::local_user { $user:
    group => $user,
  }

  # Configuration
  $conf_dir = '/etc/streamloader'
  file { 'streamloader_dir':
    ensure  => directory,
    path    => $conf_dir,
    owner   => $user,
    group   => $user,
    require => Twitch::Local_user[$user],
  }

  file { $log_dir:
    ensure  => directory,
    owner   => 'syslog',
    group   => 'adm',
    mode    => '0755',
    require => Class['::rsyslog']
  }
  -> ::rsyslog::snippet{ '40-streamloader':
    ensure  => $ensure,
    content => template("${module_name}/rsyslog.conf.erb")
  }
  -> logrotate::rule{ 'streamloader':
    ensure          => $ensure,
    path            => "${log_dir}/*.log",
    missingok       => true,
    rotate          => 48,
    rotate_every    => 'hour',
    sharedscripts   => true,
    compress        => true,
    delaycompress   => false,
    compresscmd     => '/bin/bash',
    compressoptions => '-c "dd iflag=direct bs=128k status=none | gzip -1 | dd bs=128k oflag=direct status=none"',
    compressext     => '.gz',
    create          => true,
    create_mode     => '0644',
    create_owner    => 'syslog',
    create_group    => 'adm',
    postrotate      => '/usr/local/bin/rsyslog_reopen_logs.sh'
  }

}
