class twitch_streamloader::media {
  class { 'twitch_streamloader':
    binary	=> 'streamloader_media',
  }

  #include twitch_nrdp

  twitch_systemd::unit_file { 'streamloader-media.service':
    ensure    => $ensure,
    content   => template("${module_name}/streamloader-media.service.erb"),
    subscribe => File['streamloader_dir'],
  }

  twitch_svclogs::logfile { 'streamloader-media':
    log_dir            => '/var/log/jtv',
    filename           => 'streamloader-media.log',
    log_group_name     => '/streamloader/streamloader-media.log',
    datetime_format    => '%b %d %H:%M:%S',
    use_default_region => true,
  }

  $systemd_enabled = $ensure ? {
    'absent'  => false,
    'present' => true,
    default   => false,
  }

  $systemd_ensure = $systemd_enabled ? {
    true    => 'running',
    false   => 'stopped',
    default => 'stopped',
  }

  service { 'streamloader-media':
    ensure     => $systemd_ensure,
    enable     => $systemd_enabled,
    hasrestart => true,
    restart    => 'systemctl reload streamloader-media',
    require    => Twitch_systemd::Unit_file['streamloader-media.service'],
    subscribe  => Twitch_systemd::Unit_file['streamloader-media.service'],
  }
}
