class twitch_streamloader::relay {
  class { 'twitch_streamloader':
    binary => 'streamloader_relay',
  }

  #include twitch_nrdp

  twitch_systemd::unit_file { 'streamloader-relay.service':
    ensure    => $ensure,
    content   => template("${module_name}/streamloader-relay.service.erb"),
    subscribe => File['streamloader_dir'],
  }

  twitch_svclogs::logfile { 'streamloader-relay':
    log_dir            => '/var/log/jtv',
    filename           => 'streamloader-relay.log',
    log_group_name     => '/streamloader/streamloader-relay.log',
    datetime_format    => '%b %d %H:%M:%S',
    use_default_region => true,
  }

  $systemd_enabled = $ensure ? {
    'absent'  => false,
    'present' => true,
    default   => false,
  }

  $systemd_ensure = $systemd_enabled ? {
    true    => 'running',
    false   => 'stopped',
    default => 'stopped',
  }

  service { 'streamloader-relay':
    ensure     => $systemd_ensure,
    enable     => $systemd_enabled,
    hasrestart => true,
    restart    => 'systemctl reload streamloader-relay',
    require    => Twitch_systemd::Unit_file['streamloader-relay.service'],
    subscribe  => Twitch_systemd::Unit_file['streamloader-relay.service'],
  }
}
