# configs twitch stricken host logger
class twitch_stricken_host_logger::config () {
  if str2bool($::systemd) {
    twitch_systemd::unit_file { 'stricken_host_logger.service':
      content => template("${module_name}/stricken_host_logger.service.erb"),
    }

  } else {
    file { '/etc/init.d/stricken_host_logger':
      ensure => 'file',
      source => 'puppet:///modules/twitch_stricken_host_logger/stricken_host_logger.init',
      owner  => 'root',
      group  => 'root',
      mode   => '0755',
    }
  }
}
